<?php

namespace App\Helpers;

class SteamHelper
{
    /**
     * Convert SteamID64 to legacy STEAM_0:X:Y format
     *
     * @param string|int $steamId64
     * @return string
     */
    public static function steamId64ToLegacy($steamId64)
    {
        if (!is_numeric($steamId64)) {
            return 'Unknown SteamID';
        }
        
        $steamId64 = (int)$steamId64;
        $steamId64 -= 76561197960265728; // Steam magic number
        
        $y = $steamId64 >> 1;
        $x = $steamId64 & 1;
        
        return "STEAM_0:{$x}:{$y}";
    }

    /**
     * Convert legacy STEAM_0:X:Y format to SteamID64
     *
     * @param string $steamId
     * @return string|null
     */
    public static function legacyToSteamId64($steamId)
    {
        if (!preg_match('/^STEAM_0:([0-1]):([0-9]+)$/', $steamId, $matches)) {
            return null;
        }
        
        $x = (int)$matches[1];
        $y = (int)$matches[2];
        
        return (string)(($y * 2) + $x + 76561197960265728);
    }

    /**
     * Get Steam profile URL from SteamID64
     *
     * @param string $steamId64
     * @return string
     */
    public static function getProfileUrl($steamId64)
    {
        return 'https://steamcommunity.com/profiles/' . $steamId64;
    }
}